package furny.swing.admin.tags;

import java.util.Arrays;
import java.util.Comparator;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

import furny.entities.TagType;

/**
 * Combobox to choose a tag type.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
@SuppressWarnings("serial")
public class TagComboBox extends JComboBox {

  /**
   * Instantiates a new tag combo box.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public TagComboBox() {
    final TagType[] tags = TagType.values();
    Arrays.sort(tags, new Comparator<TagType>() {
      @Override
      public int compare(final TagType o1, final TagType o2) {
        return o2.getRanking() - o1.getRanking();
      }
    });

    setModel(new DefaultComboBoxModel(tags));
  }

  /**
   * Gets the selected tag type.
   * 
   * @return the selected tag type
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public TagType getSelectedTagType() {
    return (TagType) getSelectedItem();
  }

}
